<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}
require_once __DIR__ . '/includes/db.php';

// Auth Check
if (!isset($_SESSION['ls_admin_logged_in'])) {
    header('Location: index.php');
    exit;
}

$message = '';
$messageType = '';

// Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $smtp_host = trim($_POST['smtp_host'] ?? '');
    $smtp_port = (int)($_POST['smtp_port'] ?? 587);
    $smtp_user = trim($_POST['smtp_user'] ?? '');
    $smtp_pass = trim($_POST['smtp_pass'] ?? '');
    $smtp_from_email = trim($_POST['smtp_from_email'] ?? '');
    $smtp_from_name = trim($_POST['smtp_from_name'] ?? '');
    $lemon_secret = trim($_POST['lemon_secret'] ?? '');

    try {
        $fields = [
            'smtp_host' => $smtp_host,
            'smtp_port' => $smtp_port,
            'smtp_user' => $smtp_user,
            'smtp_from_email' => $smtp_from_email,
            'smtp_from_name' => $smtp_from_name,
            'lemon_secret' => $lemon_secret
        ];

        $setClause = [];
        $params = [];

        foreach ($fields as $key => $value) {
            $setClause[] = "$key = :$key";
            $params[":$key"] = $value;
        }

        // Only update password if provided
        if (!empty($smtp_pass)) {
            $setClause[] = "smtp_pass = :smtp_pass";
            $params[':smtp_pass'] = $smtp_pass;
        }

        $sql = "UPDATE settings SET " . implode(', ', $setClause) . " WHERE id = 1";

        $stmt = $pdo->prepare($sql);
        $stmt->execute($params);

        if (isset($_POST['test_smtp'])) {
            $test_email = trim($_POST['test_email'] ?? '');
            if (empty($test_email)) {
                $message = "Please enter an email address to send the test email to.";
                $messageType = 'error';
            }
            else {
                // IMPLEMENT FAIL-SAFE INCLUSION:
                $required_files = [
                    __DIR__ . '/libs/PHPMailer/src/Exception.php',
                    __DIR__ . '/libs/PHPMailer/src/PHPMailer.php',
                    __DIR__ . '/libs/PHPMailer/src/SMTP.php'
                ];
                foreach ($required_files as $file) {
                    if (file_exists($file)) {
                        require_once $file;
                    }
                    else {
                        die("<div style='background:#7f1d1d; color:white; padding:20px; font-family:sans-serif; border-radius:8px;'><strong>System Halt:</strong> Missing PHPMailer dependency. Expected to find file at: <code>" . htmlspecialchars($file) . "</code>. Please verify your folder structure.</div>");
                    }
                }

                $mail = new \PHPMailer\PHPMailer\PHPMailer(true);

                try {
                    $mail->isSMTP();
                    $mail->Host = $smtp_host;
                    $mail->SMTPAuth = true;
                    $mail->Username = $smtp_user;
                    // If the user provided a new password, use it. Otherwise fetch the old one.
                    if (!empty($smtp_pass)) {
                        $mail->Password = $smtp_pass;
                    }
                    else {
                        $oldSettings = $pdo->query("SELECT smtp_pass FROM settings WHERE id = 1")->fetch(PDO::FETCH_ASSOC);
                        $mail->Password = $oldSettings['smtp_pass'] ?? '';
                    }
                    $mail->Port = $smtp_port;

                    if ($smtp_port == 465) {
                        $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_SMTPS;
                    }
                    elseif ($smtp_port == 587 || $smtp_port == 2525) {
                        $mail->SMTPSecure = \PHPMailer\PHPMailer\PHPMailer::ENCRYPTION_STARTTLS;
                    }
                    else {
                        $mail->SMTPSecure = '';
                    }

                    $mail->setFrom($smtp_from_email, $smtp_from_name);
                    $mail->addAddress($test_email);

                    $mail->isHTML(true);
                    $mail->Subject = 'SMTP Configuration Test - BioScript Authority';
                    $mail->Body = 'This is a test email sent from the BioScript Authority Control Center. Your SMTP settings are correctly configured!';

                    $mail->send();
                    $message = "Settings saved & Test Email successfully sent to $test_email!";
                    $messageType = 'success';
                }
                catch (Exception $e) {
                    $message = "Settings saved, but Test Email failed: " . $mail->ErrorInfo;
                    $messageType = 'error';
                }
            }
        }
        else {
            $message = "Settings updated successfully.";
            $messageType = 'success';
        }

    }
    catch (PDOException $e) {
        $message = "Database Error: " . $e->getMessage();
        $messageType = 'error';
    }
}

// Fetch Settings
$stmt = $pdo->query("SELECT * FROM settings WHERE id = 1");
$settings = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$settings) {
    // Should not happen if sync_db.php ran
    $settings = [
        'smtp_host' => '', 'smtp_port' => 587, 'smtp_user' => '',
        'smtp_pass' => '', 'smtp_from_email' => '', 'smtp_from_name' => '',
        'lemon_secret' => ''
    ];
}
?>
<!DOCTYPE html>
<html lang="en" class="dark">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>System Settings - License Authority</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        slate: { 850: '#1e293b', 950: '#0f172a' },
                        primary: { 500: '#6366f1', 600: '#4f46e5' }
                    },
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                        mono: ['JetBrains Mono', 'monospace'],
                    }
                }
            }
        }
    </script>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500&display=swap"
        rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <style>
        .ui-enterprise {
            font-family: 'Inter', sans-serif;
            --ent-primary: #2563eb;
            --ent-primary-dark: #1d4ed8;
            --ent-surface: #0f172a;
            --ent-card: #1e293b;
            --ent-border: #334155;
            --ent-border-strong: #475569;
            --ent-text: #f8fafc;
            --ent-muted: #94a3b8;
            --ent-accent: #3b82f6;
            --ent-success: #10b981;
            --ent-warning: #f59e0b;
            --ent-danger: #ef4444;
        }

        .ui-enterprise .ent-glass {
            background: rgba(15, 23, 42, 0.85);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
            border: 1px solid var(--ent-border-strong);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.5);
        }

        .ui-enterprise .ent-btn-primary {
            background: var(--ent-primary);
            color: white;
            transition: all 0.2s;
            box-shadow: 0 2px 4px rgba(37, 99, 235, 0.3);
        }

        .ui-enterprise .ent-btn-primary:hover {
            background: var(--ent-primary-dark);
            box-shadow: 0 4px 12px rgba(37, 99, 235, 0.4);
        }

        .ui-enterprise .ent-btn-primary:active {
            transform: scale(0.98);
        }

        /* Custom Scrollbar */
        .ui-enterprise ::-webkit-scrollbar {
            width: 6px;
            height: 6px;
        }

        .ui-enterprise ::-webkit-scrollbar-track {
            background: var(--ent-surface);
        }

        .ui-enterprise ::-webkit-scrollbar-thumb {
            background: var(--ent-border-strong);
            border-radius: 3px;
        }

        .ui-enterprise ::-webkit-scrollbar-thumb:hover {
            background: var(--ent-muted);
        }

        .glass-panel {
            background: rgba(30, 41, 59, 0.7);
            backdrop-filter: blur(12px);
            -webkit-backdrop-filter: blur(12px);
            border: 1px solid rgba(255, 255, 255, 0.05);
        }
    </style>
</head>

<body class="ui-enterprise bg-slate-950 text-slate-100 h-screen flex overflow-hidden font-sans">

    <!-- Sidebar -->
    <aside class="w-64 bg-slate-950 border-r border-slate-800 flex flex-col hidden md:flex shrink-0 z-20">
        <div class="p-6 border-b border-slate-800 flex items-center space-x-3">
            <div class="w-8 h-8 bg-blue-600 rounded flex items-center justify-center border border-blue-500 shadow-sm">
                <i class="fas fa-layer-group text-white text-sm"></i>
            </div>
            <div>
                <h1 class="text-base font-black text-white tracking-widest uppercase leading-tight">Guard<span
                        class="text-blue-500">Node</span></h1>
                <p class="text-[9px] text-slate-500 font-bold uppercase tracking-widest">Digital Infrastructure</p>
            </div>
        </div>

        <nav class="flex-1 py-6 space-y-1">
            <p class="px-6 text-[10px] font-black text-slate-500 uppercase tracking-widest mb-3">Control Plane</p>

            <a href="dashboard.php"
                class="flex items-center space-x-3 px-6 py-3 text-slate-400 hover:bg-slate-900 border-l-2 border-transparent hover:border-slate-700 transition-all group">
                <i class="fas fa-satellite-dish w-5 text-center group-hover:text-slate-300 transition-colors"></i>
                <span class="font-semibold tracking-wide text-sm">License Overview</span>
            </a>

            <a href="orders.php"
                class="flex items-center space-x-3 px-6 py-3 text-slate-400 hover:bg-slate-900 border-l-2 border-transparent hover:border-slate-700 transition-all group">
                <i class="fas fa-shopping-cart w-5 text-center group-hover:text-slate-300 transition-colors"></i>
                <span class="font-semibold tracking-wide text-sm">WooCommerce Orders</span>
            </a>

            <a href="settings.php"
                class="flex items-center space-x-3 px-6 py-3 bg-slate-900 text-blue-400 border-l-2 border-blue-500 transition-all group">
                <i class="fas fa-sliders-h w-5 text-center"></i>
                <span class="font-semibold tracking-wide text-sm">Global Settings</span>
            </a>
        </nav>

        <div class="p-4 border-t border-slate-800">
            <a href="index.php?logout=true"
                class="flex items-center justify-center space-x-2 w-full px-4 py-2 hover:bg-slate-900 text-slate-500 hover:text-red-400 border border-transparent hover:border-slate-800 rounded transition-all text-xs font-bold uppercase tracking-wider">
                <i class="fas fa-power-off"></i>
                <span>Terminate Session</span>
            </a>
        </div>
    </aside>

    <!-- Main Content -->
    <main class="flex-1 overflow-y-auto p-8 lg:p-12 relative">
        <!-- Background Glow -->
        <div
            class="absolute top-0 left-0 w-full h-96 bg-gradient-to-b from-primary-900/20 to-transparent pointer-events-none">
        </div>

        <header class="mb-10 relative z-10">
            <h2 class="text-3xl font-bold text-white mb-2 tracking-tight">System Configuration</h2>
            <p class="text-slate-400">Manage SMTP servers and Webhook integrations.</p>
        </header>

        <?php if ($message): ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                Swal.fire({
                    icon: '<?php echo $messageType; ?>',
                    title: '<?php echo $messageType === 'success' ? 'Success' : 'Error'; ?>',
                    text: '<?php echo addslashes($message); ?>',
                    background: '#1e293b',
                    color: '#fff',
                    confirmButtonColor: '#3b82f6'
                })
            });
        </script>
        <?php
endif; ?>

        <form method="POST" class="max-w-4xl relative z-10 space-y-8">

            <!-- SMTP Settings -->
            <div class="glass-panel p-8 rounded-2xl">
                <h3 class="text-xl font-bold text-white mb-6 flex items-center">
                    <i class="fas fa-envelope text-primary-500 mr-3"></i> SMTP Configuration
                </h3>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="col-span-2">
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">SMTP
                            Host</label>
                        <input type="text" name="smtp_host"
                            value="<?php echo htmlspecialchars($settings['smtp_host']); ?>"
                            placeholder="smtp.example.com"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">SMTP
                            Port</label>
                        <input type="number" name="smtp_port"
                            value="<?php echo htmlspecialchars((string)$settings['smtp_port']); ?>" placeholder="587"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">SMTP
                            Username</label>
                        <input type="text" name="smtp_user"
                            value="<?php echo htmlspecialchars($settings['smtp_user']); ?>"
                            placeholder="user@example.com"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                    </div>

                    <div class="col-span-2">
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">SMTP
                            Password</label>
                        <input type="password" name="smtp_pass" placeholder="••••••••"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                        <p class="text-xs text-slate-500 mt-1">Leave blank to keep current password.</p>
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">From
                            Email</label>
                        <input type="email" name="smtp_from_email"
                            value="<?php echo htmlspecialchars($settings['smtp_from_email']); ?>"
                            placeholder="noreply@bioscript.com"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                    </div>

                    <div>
                        <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">From
                            Name</label>
                        <input type="text" name="smtp_from_name"
                            value="<?php echo htmlspecialchars($settings['smtp_from_name']); ?>"
                            placeholder="BioScript License Authority"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-primary-500 focus:ring-1 focus:ring-primary-500 focus:outline-none transition-all">
                    </div>
                </div>
            </div>

            <!-- Lemon Squeezy Settings -->
            <div class="glass-panel p-8 rounded-2xl">
                <h3 class="text-xl font-bold text-white mb-6 flex items-center">
                    <i class="fas fa-lemon text-yellow-400 mr-3"></i> Lemon Squeezy Integration
                </h3>

                <div>
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Webhook
                        Secret</label>
                    <div class="relative">
                        <input type="password" name="lemon_secret"
                            value="<?php echo htmlspecialchars($settings['lemon_secret']); ?>"
                            class="w-full bg-slate-950/50 border border-slate-700 rounded-xl px-4 py-3 text-white focus:border-yellow-400 focus:ring-1 focus:ring-yellow-400 focus:outline-none transition-all font-mono">
                        <i class="fas fa-lock absolute right-4 top-4 text-slate-500"></i>
                    </div>
                    <p class="text-xs text-slate-500 mt-2">Used to verify webhook signatures from Lemon Squeezy.</p>
                </div>
            </div>

            <!-- Actions -->
            <div class="glass-panel p-8 rounded-2xl flex flex-col md:flex-row items-center justify-between gap-6">
                <!-- Test Email Input -->
                <div class="flex-1 w-full max-w-md">
                    <label class="block text-xs font-bold text-slate-400 uppercase tracking-wider mb-2">Test Email
                        Address</label>
                    <div class="flex">
                        <input type="email" name="test_email" placeholder="test@example.com"
                            class="flex-1 bg-slate-950/50 border border-slate-700 border-r-0 rounded-l-xl px-4 py-3 text-white focus:border-blue-500 focus:ring-1 focus:ring-blue-500 focus:outline-none transition-all">
                        <button type="submit" name="test_smtp"
                            class="bg-slate-800 hover:bg-slate-700 text-blue-400 font-bold px-6 border border-slate-700 border-l-0 rounded-r-xl transition-all flex items-center justify-center">
                            <i class="fas fa-paper-plane mr-2"></i> Send Test
                        </button>
                    </div>
                </div>

                <!-- Save Changes -->
                <div>
                    <button type="submit" name="save_settings"
                        class="bg-primary-600 hover:bg-primary-500 text-white font-bold py-4 px-8 rounded-xl shadow-lg shadow-primary-600/20 transition-all flex items-center space-x-2 w-full md:w-auto mt-6 md:mt-0 lg:mt-6">
                        <i class="fas fa-save"></i>
                        <span>Save Changes</span>
                    </button>
                </div>
            </div>

        </form>
    </main>
</body>

</html>